/**
  Copyright (c) 2010 Freescale Semiconductor
  
  \file  	  Flib2.c
  \brief	  This is the Flash Library Auxiliar #2 File
  \brief	  Provides furhter functionality to animate graphics
  \author	  Freescale Semiconductor
  \author	  Automotive Systems Solutions Engineering
  \author	  IM, b06623
  \version	  2.0
  \revision	  $Revision: 137 $
  \date  	  $Date: 2011-01-11 12:49:40 -0600 (Tue, 11 Jan 2011) $  
  
* History:  5/Jan/2009 - Initial Version
*           11/May/2009 - Last changes applied
*			10/Sep/2010 - If interpolation is Table, takes values out of the table.

* MISRA VIOLATIONS:
	- [ MISRA 11.2 ]
	- [ MISRA 16.9 ]

* Copyright (c) 2010, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
  
*/

#include "FlibInternal.h"
#include "Display.h"

/**
* \brief	FLIB_AnimSetupPos - Sets up a position animation sequence.
* \brief	Animation setup should be done in the callback function
* \brief	registered with the FLIB_Setup call.
* \author	IM, b06623
* \param	Layer: Graphic Object where the animation is performed.
* \param	duration: Number of frames the animation takes. 
* \param	pos: pointer to position animation description.
* \return	FLIB_Error_t: FLIB_ERROR_OK (service was accepted),
* \return	FLIB_ERROR_ANIM_POS (Error in position animation parameters)
* \todo
*/
FLIB_Error_t FLIB_AnimSetupPos
(
	uint8_t Layer,
	uint32_t duration,
	const Graphics_Object_t *gobject,	
	const FLIB_AnimPos_t* pos				
)

{ 
    int32_t x_fix;
    int32_t y_fix;


    if(FLIB_AnimationData[Layer].duration != 0u)
    {
		return FLIB_ERROR_LAYER_ACTIVE;
    }
    if(duration < 2)
    {
		return FLIB_ERROR_PARAM;
    }    
    if(pos == NULL_PTR)
    {
		return FLIB_ERROR_ANIM_POS;
    } 
	
	FLIB_AnimationData[Layer].duration = duration;
	FLIB_AnimationData[Layer].currentFrame = 0;

	if(gobject != NULL_PTR)
	{
	    Graphics_CopyGraphicObject(gobject, &FLIB_AnimationData[Layer].gobject);
	}
	else
	{
	    FLIB_AnimationData[Layer].gobject.address = (uint32_t)NULL_PTR;
	}

	FLIB_AnimationData[Layer].anim.pos = pos;
	if(pos->transition != FLIB_TABLE)
	{	
		FLIB_AnimationData[Layer].state.x = ((int32_t)pos->start.x)*65536;
    	FLIB_AnimationData[Layer].state.y = ((int32_t)pos->start.y)*65536;
					
		/* calculation of delta increments for each variable */	
		x_fix = ((int32_t)(pos->end.x - pos->start.x))*65536;
		y_fix = ((int32_t)(pos->end.y - pos->start.y))*65536;

		x_fix = x_fix/((int32_t)duration - 1);
		y_fix = y_fix/((int32_t)duration - 1);	


		/* In case of dynamic animation, there is an steady speed state */
		if(pos->transition == FLIB_DYNAMIC)
		{
		    FLIB_AnimationData[Layer].state.dx	= x_fix + (x_fix/2);	    
		    FLIB_AnimationData[Layer].state.dy 	= y_fix + (y_fix/2);
		}
		else
		{	
		    FLIB_AnimationData[Layer].state.dx = x_fix;
		    FLIB_AnimationData[Layer].state.dy = y_fix;
		}
	}
	/* Table animation init values */
	else
	{	
		FLIB_AnimationData[Layer].state.x = ((int32_t)pos->inter_Table[0].x)*65536;
		FLIB_AnimationData[Layer].state.y = ((int32_t)pos->inter_Table[0].y)*65536;
	}
			
	/* VIOLATION TO [ MISRA 11.2 ] Rationale: Is the only way to indicate that the pointer value is null */
	/* Violation applies to the following 6 lines of C code */     
	FLIB_AnimationData[Layer].anim.alpha = NULL_PTR;
	FLIB_AnimationData[Layer].anim.color = NULL_PTR;
	FLIB_AnimationData[Layer].anim.scrolling = NULL_PTR;
	FLIB_AnimationData[Layer].anim.scaling = NULL_PTR;
	FLIB_AnimationData[Layer].anim.object = NULL_PTR;
	/* VIOLATION TO [ MISRA 16.9 ] Rationale: Is the only way to indicate that the function pointer is null (used as callback) */  
	FLIB_AnimationData[Layer].callback = NULL_PTR;
	

    return FLIB_ERROR_OK;
}
